<?php

class AuthMiddleware {
    public static function verifyToken() {
        $headers = getallheaders();
        $auth = $headers['Authorization'] ?? '';
        
        if (!preg_match('/Bearer\s+(.+)/', $auth, $matches)) {
            Response::error('Token manquant', 'NO_TOKEN', 401);
        }
        
        $token = $matches[1];
        $pdo = Database::connect();
        
        try {
            $stmt = $pdo->prepare('
                SELECT user_id FROM oauth_tokens 
                WHERE access_token = ? AND expires_at > NOW()
            ');
            $stmt->execute([$token]);
            $result = $stmt->fetch();
            
            if (!$result) {
                Response::error('Token invalide ou expiré', 'INVALID_TOKEN', 401);
            }
            
            return $result['user_id'];
        } catch (Exception $e) {
            Response::error('Erreur authentification', 'AUTH_ERROR', 500);
        }
    }
}
