<?php

require_once '../config/database.php';
require_once '../config/cors.php';
require_once '../utils/response.php';
require_once '../utils/auth_middleware.php';

setCORS();

$user_id = AuthMiddleware::verifyToken();

if (empty($_GET['email'])) {
    Response::error('Email manquant', 'MISSING_EMAIL', 400);
}

$pdo = Database::connect();

try {
    $stmt = $pdo->prepare('
        SELECT last_sync, version FROM user_data WHERE user_id = ?
    ');
    $stmt->execute([$user_id]);
    $data = $stmt->fetch();
    
    if (!$data) {
        Response::success([
            'synced' => false,
            'message' => 'Aucune donnée synchronisée'
        ], 'Statut récupéré', 200);
    }
    
    Response::success([
        'synced' => true,
        'last_sync' => $data['last_sync'],
        'version' => $data['version']
    ], 'Statut récupéré', 200);
    
} catch (Exception $e) {
    error_log($e->getMessage());
    Response::error('Erreur récupération statut', 'STATUS_ERROR', 500);
}
