<?php

class Database {
    private static $pdo = null;
    private static $config = [
        'host' => 'localhost',
        'db_name' => 'workzen_db',
        'user' => 'root',
        'password' => '',
        'charset' => 'utf8mb4'
    ];

    public static function connect() {
        if (self::$pdo === null) {
            try {
                $dsn = "mysql:host=" . self::$config['host'] 
                    . ";dbname=" . self::$config['db_name'] 
                    . ";charset=" . self::$config['charset'];
                
                self::$pdo = new PDO($dsn, self::$config['user'], self::$config['password']);
                self::$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                self::$pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
            } catch (PDOException $e) {
                die(json_encode(['success' => false, 'message' => 'Erreur de connexion BD']));
            }
        }
        return self::$pdo;
    }
}
