<?php

require_once '../config/database.php';
require_once '../config/cors.php';
require_once '../utils/response.php';
require_once '../utils/auth_middleware.php';

setCORS();

$user_id = AuthMiddleware::verifyToken();

$pdo = Database::connect();

try {
    $stmt = $pdo->prepare('DELETE FROM oauth_tokens WHERE user_id = ?');
    $stmt->execute([$user_id]);
    
    Response::success(null, 'Déconnexion réussie', 200);
    
} catch (Exception $e) {
    error_log($e->getMessage());
    Response::error('Erreur déconnexion', 'LOGOUT_ERROR', 500);
}
