<?php

require_once '../config/database.php';
require_once '../config/cors.php';
require_once '../utils/response.php';

setCORS();

$data = json_decode(file_get_contents('php://input'), true);

if (empty($data['email']) || empty($data['password'])) {
    Response::error('Email ou mot de passe manquant', 'MISSING_CREDENTIALS', 400);
}

$email = filter_var($data['email'], FILTER_VALIDATE_EMAIL);
if (!$email) {
    Response::error('Email invalide', 'INVALID_EMAIL', 400);
}

$pdo = Database::connect();

try {
    // Récupérer l'utilisateur
    $stmt = $pdo->prepare('SELECT id, password_hash FROM users WHERE email = ?');
    $stmt->execute([$email]);
    $user = $stmt->fetch();
    
    if (!$user || !password_verify($data['password'], $user['password_hash'])) {
        Response::error('Identifiants invalides', 'INVALID_CREDENTIALS', 401);
    }
    
    // Générer tokens
    $access_token = bin2hex(random_bytes(32));
    $refresh_token = bin2hex(random_bytes(32));
    $expires_at = date('Y-m-d H:i:s', strtotime('+7 days'));
    
    // Stocker les tokens
    $stmt = $pdo->prepare('
        INSERT INTO oauth_tokens (user_id, access_token, refresh_token, expires_at) 
        VALUES (?, ?, ?, ?)
    ');
    $stmt->execute([$user['id'], $access_token, $refresh_token, $expires_at]);
    
    Response::success([
        'access_token' => $access_token,
        'refresh_token' => $refresh_token,
        'expires_in' => 604800,
        'user_id' => $user['id']
    ], 'Authentification réussie', 200);
    
} catch (Exception $e) {
    error_log($e->getMessage());
    Response::error('Erreur authentification', 'AUTH_ERROR', 500);
}
